/******************************************************************************
 * %Id:
 *
 * FileName		:rmt_bridge_data.h
 *
 * Description	:Definition header of data used in bridge
 *
 *
 * Copyright	:Panasonic Corporation.
 *
 *****************************************************************************/
#ifndef	_INP_BRIDGE_DATA_H_
#define	_INP_BRIDGE_DATA_H_

#include <linux/iosc/iosc-devices.h>

#define INP_MAX_FD_NAME	256
#define INP_CODE_LEN	256
#define INP_MASK_LEN	256
#define INP_READ_UNIT	16

typedef		short	INP_ID;
typedef		short	INP_DEV;


typedef struct {
    int cmd;
    int (*handler)(int,unsigned int,void *);
} inp_command_t;

typedef struct _inp_data_t {
	char				inp_dev;
	char				reserved1;
	short				code;			/* input event */
	unsigned short		utime;			/* time code: get_tim() returns code */
	char				reserved2[2];
	unsigned long		ltime;			/* time code: get_tim() returns code */
} inp_data_t;

/* structure used for inquiring input library Context. */
typedef enum _inp_type_t {
	INP_ALL_CODE, 
	INP_SPEC_CODE, 
	INP_NO_CODE
} inp_type_t;

typedef struct _inp_context_t {
	inp_type_t			inp_type;		/* type of input */
	inp_type_t			ar_type;		/* type of auto repeat */
	unsigned short		ar1;
	unsigned short		ar2;
	short				code_len;
	short				mask_len;
	unsigned short		codes[INP_CODE_LEN];
	unsigned short		masks[INP_MASK_LEN];
} inp_context_t;


/* structure used for inquiring input library status. */
typedef struct _inp_status_t {
	long				status;
	long				n_event;
	long				n_input;
	long				n_overflow;
} inp_status_t;


/* Device mode status for input libary. */
typedef struct _inp_devmode_t {
	long			devmode;		/* event notifification way */
	union {
		struct {
		/* defined by MIS: lower 12bit is valid. */
			unsigned short	reserved:4;
			unsigned short	sysbit:4;
			unsigned short	kikibit:8;
		} kasei;
		char	reserved[16];
	} mode;
} inp_devmode_t;


/* Property for input libary. */
typedef struct inp_prop_t {
	short				ev_flag;		/* event notifification way */
	short				of_flag;		/* buffer overflow flag */
	short				ev_que;			/* que which events send. */
	long				reserve;
} inp_prop_t;


/* structure used for reading raw event code. */
typedef struct _inp_devdt_t {
	long				keyon;			/* 0:OFF, Non-0:ON */
	long				opt;			/* OPTION FLAG */
	unsigned char		data[4];		/* data area pointer */
} inp_devdt_t;



/********************************
*       Macro Definition(s)     *
********************************/
/* Pre-defined Input Device identifier */
enum {
	INP_D_FP,
	INP_D_RC0,	/* Primary Remote controller */
	INP_D_KBD0,
	INP_D_RC1,	/* Secondary Remote controller */
	INP_D_CNTL,	/* Secondary Remote controller */
	INP_D_MAX,
};


/* apply for ev_flag */
enum {
	INP_E_BUFFER = 1,
	INP_E_NOTIFY,
	INP_E_SEND,
};


/********************************
* Bridge I/F                    *
********************************/
typedef struct _inp_open_t {
	int					serr;
	INP_ID				inp;
} inp_open_t;

typedef struct _inp_close_t {
	int					serr;
	INP_ID				inp;
} inp_close_t;

typedef struct _inp_read_t {
	int					serr;
	INP_ID				inp;
	long				n;
	inp_data_t			b[INP_READ_UNIT];
} inp_read_t;

typedef struct _inp_getdata_t {
	int					serr;
	INP_ID				inp;
	INP_DEV				in;
	inp_devdt_t			b;
} inp_getdata_t;

typedef struct _inp_enable_t {
	int					serr;
	INP_ID				inp;
} inp_enable_t;

typedef struct _inp_disable_t {
	int					serr;
	INP_ID				inp;
} inp_disable_t;

typedef struct _inp_clear_t {
	int					serr;
	INP_ID				inp;
} inp_clear_t;

typedef struct _inp_cntl_t {
	int					serr;
	INP_ID				inp;
	INP_DEV				in;
	inp_context_t		c;
} inp_cntl_t;

typedef struct _inp_property_t {
	int					serr;
	INP_ID				inp;
	inp_prop_t			prop;
} inp_property_t;

typedef struct _inp_chmode_t {
	int					serr;
	INP_ID				inp;
	INP_DEV				in;
	inp_devmode_t		mode;
} inp_chmode_t;



typedef struct _inp_cberror_t {
	INP_ID				inp;
	asn_response_t 		msg;
} inp_cberror_t;

typedef struct _inp_cbevent_t {
	INP_ID				inp;
	inp_data_t			data;
} inp_cbevnet_t;

#endif	/* _INP_BRIDGE_DATA_H_ */

